/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.movingelevators.blocks.CamoBlock;
import com.supermartijn642.movingelevators.blocks.CamoBlockEntity;
import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.blocks.DisplayBlockEntity;
import com.supermartijn642.movingelevators.blocks.ElevatorInputBlockEntity;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class DisplayBlock
extends CamoBlock {
    public static final int BUTTON_COUNT = 3;
    public static final int BUTTON_COUNT_BIG = 7;
    public static final float BUTTON_HEIGHT = 0.125f;

    public DisplayBlock(String registryName, BlockBehaviour.Properties properties) {
        super(registryName, properties, DisplayBlockEntity::new);
    }

    @Override
    protected boolean onRightClick(BlockState state, Level worldIn, CamoBlockEntity blockEntity, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult rayTraceResult) {
        DisplayBlockEntity displayTile;
        if (blockEntity instanceof DisplayBlockEntity && (displayTile = (DisplayBlockEntity)blockEntity).getFacing() == rayTraceResult.m_82434_()) {
            if (!worldIn.f_46443_) {
                int displayCat = displayTile.getDisplayCategory();
                Vec3 hitVec = rayTraceResult.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                double hitHorizontal = rayTraceResult.m_82434_().m_122434_() == Direction.Axis.Z ? hitVec.f_82479_ : hitVec.f_82481_;
                double hitY = hitVec.f_82480_;
                if (hitHorizontal > 0.0625 && hitHorizontal < 0.9375) {
                    BlockEntity blockEntity2;
                    BlockPos inputTilePos = null;
                    int button_count = -1;
                    int height = -1;
                    if (displayCat == 1) {
                        if (hitY > 0.0625 && hitY < 0.9375) {
                            inputTilePos = pos.m_7495_();
                            button_count = 3;
                            height = 1;
                        }
                    } else if (displayCat == 2) {
                        if (hitY > 0.0625) {
                            inputTilePos = pos.m_7495_();
                            button_count = 7;
                            height = 2;
                        }
                    } else if (displayCat == 3 && hitY < 0.9375) {
                        inputTilePos = pos.m_6625_(2);
                        button_count = 7;
                        height = 2;
                        hitY += 1.0;
                    }
                    if (inputTilePos != null && (blockEntity2 = worldIn.m_7702_(inputTilePos)) instanceof ElevatorInputBlockEntity && ((ElevatorInputBlockEntity)blockEntity2).hasGroup()) {
                        int above;
                        ElevatorInputBlockEntity inputTile = (ElevatorInputBlockEntity)blockEntity2;
                        ElevatorGroup group = inputTile.getGroup();
                        int index = inputTile.getGroup().getFloorNumber(inputTile.getFloorLevel());
                        int below = index;
                        if (below < (above = group.getFloorCount() - index - 1)) {
                            below = Math.min(below, button_count);
                            above = Math.min(above, button_count * 2 - below);
                        } else {
                            above = Math.min(above, button_count);
                            below = Math.min(below, button_count * 2 - above);
                        }
                        int startIndex = index - below;
                        int total = below + 1 + above;
                        int floorOffset = (int)Math.floor((hitY - (double)((float)height - (float)total * 0.125f) / 2.0) / 0.125) + startIndex - index;
                        if (player == null || player.m_21120_(handIn).m_41619_() || !(player.m_21120_(handIn).m_41720_() instanceof DyeItem)) {
                            inputTile.getGroup().onDisplayPress(inputTile.getFloorLevel(), floorOffset);
                        } else {
                            DyeColor color = ((DyeItem)player.m_21120_(handIn).m_41720_()).m_41089_();
                            int floor = group.getFloorNumber(inputTile.getFloorLevel()) + floorOffset;
                            ControllerBlockEntity elevatorTile = group.getTileForFloor(floor);
                            if (elevatorTile != null) {
                                elevatorTile.setDisplayLabelColor(color);
                            }
                        }
                    }
                }
            }
            return true;
        }
        return super.onRightClick(state, worldIn, blockEntity, pos, player, handIn, rayTraceResult);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter reader, List<Component> tooltips, TooltipFlag advanced) {
        super.m_5871_(stack, reader, tooltips, advanced);
        tooltips.add((Component)TextComponents.translation((String)"movingelevators.elevator_display.tooltip").color(ChatFormatting.AQUA).get());
    }
}

